/*
 * Svix API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 1.1.1
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// MessageIn struct for MessageIn
type MessageIn struct {
	Application *ApplicationIn `json:"application,omitempty"`
	// List of free-form identifiers that endpoints can filter by
	Channels []string `json:"channels,omitempty"`
	// Optional unique identifier for the message
	EventId NullableString `json:"eventId,omitempty"`
	// The event type's name
	EventType string `json:"eventType"`
	Payload map[string]interface{} `json:"payload"`
	PayloadRetentionPeriod *int64 `json:"payloadRetentionPeriod,omitempty"`
	// List of free-form tags that can be filtered by when listing messages
	Tags []string `json:"tags,omitempty"`
	// Extra parameters to pass to Transformations (for future use)
	TransformationsParams map[string]interface{} `json:"transformationsParams,omitempty"`
}

// NewMessageIn instantiates a new MessageIn object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessageIn(eventType string, payload map[string]interface{}) *MessageIn {
	this := MessageIn{}
	this.EventType = eventType
	this.Payload = payload
	var payloadRetentionPeriod int64 = 90
	this.PayloadRetentionPeriod = &payloadRetentionPeriod
	return &this
}

// NewMessageInWithDefaults instantiates a new MessageIn object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessageInWithDefaults() *MessageIn {
	this := MessageIn{}
	var payloadRetentionPeriod int64 = 90
	this.PayloadRetentionPeriod = &payloadRetentionPeriod
	return &this
}

// GetApplication returns the Application field value if set, zero value otherwise.
func (o *MessageIn) GetApplication() ApplicationIn {
	if o == nil || o.Application == nil {
		var ret ApplicationIn
		return ret
	}
	return *o.Application
}

// GetApplicationOk returns a tuple with the Application field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageIn) GetApplicationOk() (*ApplicationIn, bool) {
	if o == nil || o.Application == nil {
		return nil, false
	}
	return o.Application, true
}

// HasApplication returns a boolean if a field has been set.
func (o *MessageIn) HasApplication() bool {
	if o != nil && o.Application != nil {
		return true
	}

	return false
}

// SetApplication gets a reference to the given ApplicationIn and assigns it to the Application field.
func (o *MessageIn) SetApplication(v ApplicationIn) {
	o.Application = &v
}

// GetChannels returns the Channels field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetChannels() []string {
	if o == nil  {
		var ret []string
		return ret
	}
	return o.Channels
}

// GetChannelsOk returns a tuple with the Channels field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetChannelsOk() (*[]string, bool) {
	if o == nil || o.Channels == nil {
		return nil, false
	}
	return &o.Channels, true
}

// HasChannels returns a boolean if a field has been set.
func (o *MessageIn) HasChannels() bool {
	if o != nil && o.Channels != nil {
		return true
	}

	return false
}

// SetChannels gets a reference to the given []string and assigns it to the Channels field.
func (o *MessageIn) SetChannels(v []string) {
	o.Channels = v
}

// GetEventId returns the EventId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetEventId() string {
	if o == nil || o.EventId.Get() == nil {
		var ret string
		return ret
	}
	return *o.EventId.Get()
}

// GetEventIdOk returns a tuple with the EventId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetEventIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return o.EventId.Get(), o.EventId.IsSet()
}

// HasEventId returns a boolean if a field has been set.
func (o *MessageIn) HasEventId() bool {
	if o != nil && o.EventId.IsSet() {
		return true
	}

	return false
}

// SetEventId gets a reference to the given NullableString and assigns it to the EventId field.
func (o *MessageIn) SetEventId(v string) {
	o.EventId.Set(&v)
}
// SetEventIdNil sets the value for EventId to be an explicit nil
func (o *MessageIn) SetEventIdNil() {
	o.EventId.Set(nil)
}

// UnsetEventId ensures that no value is present for EventId, not even an explicit nil
func (o *MessageIn) UnsetEventId() {
	o.EventId.Unset()
}

// GetEventType returns the EventType field value
func (o *MessageIn) GetEventType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.EventType
}

// GetEventTypeOk returns a tuple with the EventType field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetEventTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EventType, true
}

// SetEventType sets field value
func (o *MessageIn) SetEventType(v string) {
	o.EventType = v
}

// GetPayload returns the Payload field value
func (o *MessageIn) GetPayload() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Payload
}

// GetPayloadOk returns a tuple with the Payload field value
// and a boolean to check if the value has been set.
func (o *MessageIn) GetPayloadOk() (*map[string]interface{}, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Payload, true
}

// SetPayload sets field value
func (o *MessageIn) SetPayload(v map[string]interface{}) {
	o.Payload = v
}

// GetPayloadRetentionPeriod returns the PayloadRetentionPeriod field value if set, zero value otherwise.
func (o *MessageIn) GetPayloadRetentionPeriod() int64 {
	if o == nil || o.PayloadRetentionPeriod == nil {
		var ret int64
		return ret
	}
	return *o.PayloadRetentionPeriod
}

// GetPayloadRetentionPeriodOk returns a tuple with the PayloadRetentionPeriod field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *MessageIn) GetPayloadRetentionPeriodOk() (*int64, bool) {
	if o == nil || o.PayloadRetentionPeriod == nil {
		return nil, false
	}
	return o.PayloadRetentionPeriod, true
}

// HasPayloadRetentionPeriod returns a boolean if a field has been set.
func (o *MessageIn) HasPayloadRetentionPeriod() bool {
	if o != nil && o.PayloadRetentionPeriod != nil {
		return true
	}

	return false
}

// SetPayloadRetentionPeriod gets a reference to the given int64 and assigns it to the PayloadRetentionPeriod field.
func (o *MessageIn) SetPayloadRetentionPeriod(v int64) {
	o.PayloadRetentionPeriod = &v
}

// GetTags returns the Tags field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetTags() []string {
	if o == nil  {
		var ret []string
		return ret
	}
	return o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return &o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *MessageIn) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *MessageIn) SetTags(v []string) {
	o.Tags = v
}

// GetTransformationsParams returns the TransformationsParams field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *MessageIn) GetTransformationsParams() map[string]interface{} {
	if o == nil  {
		var ret map[string]interface{}
		return ret
	}
	return o.TransformationsParams
}

// GetTransformationsParamsOk returns a tuple with the TransformationsParams field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageIn) GetTransformationsParamsOk() (*map[string]interface{}, bool) {
	if o == nil || o.TransformationsParams == nil {
		return nil, false
	}
	return &o.TransformationsParams, true
}

// HasTransformationsParams returns a boolean if a field has been set.
func (o *MessageIn) HasTransformationsParams() bool {
	if o != nil && o.TransformationsParams != nil {
		return true
	}

	return false
}

// SetTransformationsParams gets a reference to the given map[string]interface{} and assigns it to the TransformationsParams field.
func (o *MessageIn) SetTransformationsParams(v map[string]interface{}) {
	o.TransformationsParams = v
}

func (o MessageIn) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Application != nil {
		toSerialize["application"] = o.Application
	}
	if o.Channels != nil {
		toSerialize["channels"] = o.Channels
	}
	if o.EventId.IsSet() {
		toSerialize["eventId"] = o.EventId.Get()
	}
	if true {
		toSerialize["eventType"] = o.EventType
	}
	if true {
		toSerialize["payload"] = o.Payload
	}
	if o.PayloadRetentionPeriod != nil {
		toSerialize["payloadRetentionPeriod"] = o.PayloadRetentionPeriod
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TransformationsParams != nil {
		toSerialize["transformationsParams"] = o.TransformationsParams
	}
	return json.Marshal(toSerialize)
}

type NullableMessageIn struct {
	value *MessageIn
	isSet bool
}

func (v NullableMessageIn) Get() *MessageIn {
	return v.value
}

func (v *NullableMessageIn) Set(val *MessageIn) {
	v.value = val
	v.isSet = true
}

func (v NullableMessageIn) IsSet() bool {
	return v.isSet
}

func (v *NullableMessageIn) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessageIn(val *MessageIn) *NullableMessageIn {
	return &NullableMessageIn{value: val, isSet: true}
}

func (v NullableMessageIn) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessageIn) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


